SET NOCOUNT ON
IF NOT EXISTS(
	SELECT 
		ID 
	FROM 
		SYSOBJECTS 
	WHERE 
		NAME = 'TELE_OPERADOR_AGENDA' AND XTYPE = 'U')
BEGIN
	SET NOCOUNT OFF
	
	CREATE TABLE [dbo].[TELE_OPERADOR_AGENDA](
		[CD_AGENDA] [int] IDENTITY(1,1) NOT NULL,
		[CD_CLI] [int] NOT NULL,
		[CD_USU] [int] NOT NULL,
		[DT_CAD] [datetime] NOT NULL,
		[DT_AGENDA] [datetime] NOT NULL,
		[DT_FIM] [datetime] NULL,
		[ATIVA] [bit] NOT NULL,
		[OBS] [text] NULL,
		[CD_EMP] [int] NOT NULL,
	 CONSTRAINT [PK_TELE_OPERADOR_AGENDA] PRIMARY KEY CLUSTERED 
	(
		[CD_AGENDA] ASC
	)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
	) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
	
	ALTER TABLE [dbo].[TELE_OPERADOR_AGENDA]  WITH CHECK ADD  CONSTRAINT [FK_TELE_OPERADOR_AGENDA_RC_CLI] FOREIGN KEY([CD_EMP], [CD_CLI])
	REFERENCES [dbo].[RC_CLI] ([CD_EMP], [CD_CLI])
	
	ALTER TABLE [dbo].[TELE_OPERADOR_AGENDA] CHECK CONSTRAINT [FK_TELE_OPERADOR_AGENDA_RC_CLI]
	
	ALTER TABLE [dbo].[TELE_OPERADOR_AGENDA]  WITH CHECK ADD  CONSTRAINT [FK_TELE_OPERADOR_AGENDA_TELE_GLB_USU] FOREIGN KEY([CD_USU])
	REFERENCES [dbo].[TELE_GLB_USU] ([CD_USU])
	
	ALTER TABLE [dbo].[TELE_OPERADOR_AGENDA] CHECK CONSTRAINT [FK_TELE_OPERADOR_AGENDA_TELE_GLB_USU]
	
	ALTER TABLE [dbo].[TELE_OPERADOR_AGENDA] ADD  CONSTRAINT [DF_TELE_OPERADOR_AGENDA_DT_CAD]  DEFAULT (getdate()) FOR [DT_CAD]
	
	ALTER TABLE [dbo].[TELE_OPERADOR_AGENDA] ADD  CONSTRAINT [DF_TELE_OPERADOR_AGENDA_ATIVA]  DEFAULT ((1)) FOR [ATIVA]
		
	PRINT 'TABELA TELE_OPERADOR_AGENDA INSERIDA COM SUCESSO '
END

